USE [Elerium]
GO

/****** Object:  StoredProcedure [dbo].[RP_StagingTablesProcessing]    Script Date: 9/25/2014 15:36:30 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





-- =============================================
-- Author:		<James Davis>
-- Create date: <2013-10-22>
-- Description:	<Does Merge for RewardUser from RewardUser_Staging>
-- =============================================
ALTER PROCEDURE [dbo].[RP_StagingTablesProcessing]
	@errorMessage varchar(2048) OUTPUT
AS

BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	SELECT @errorMessage = 'completed sucessfully';
	BEGIN TRY
		BEGIN TRANSACTION StagingTablesProcessing WITH MARK;

            -- insert project data into reward project staging because those projects are on new curseforge are no longer
            --being synce by the ssis package
			INSERT INTO RewardLegacyProject_Staging(ID,Status,OwnerID,Name,Stage)
			SELECT p.id,
			 CASE
			    WHEN p.Status = 8 THEN 'd'
				WHEN p.Status = 7 THEN 'n'
				WHEN p.Status = 4 THEN 
				 CASE
					WHEN p.IsExperimental = 1 THEN 'e'
					ELSE 'n' 
					END
				WHEN p.Status = 5 THEN 'd'
				WHEN p.Status = 3 THEN 'u'
				WHEN p.Status = 1 THEN 'a'
				WHEN p.Status = 2 THEN 'c'
			END as Status,
			 p.OwnerID, p.Name, 
			  CASE
			    WHEN p.Status = 7 THEN 'i'
				WHEN p.Status = 8 THEN 'x'
				WHEN p.Status = 5 THEN 'd'
				WHEN min(pf.ReleaseType) = 1 THEN 'r'
				WHEN min(pf.ReleaseType) = 2 THEN 'b'
				WHEN min(pf.ReleaseType) = 3 THEN 'a'
			END as Stage
			FROM project p 
			left join ProjectFile pf on p.id = pf.ProjectID
			GROUP BY p.id, p.Status, p.OwnerID, p.Name, p.IsExperimental

			MERGE [dbo].[RewardLegacyProject] AS TARGET
			USING RewardLegacyProject_Staging AS SOURCE
			ON (TARGET.ID = SOURCE.ID)
			WHEN MATCHED THEN 
			UPDATE SET TARGET.OwnerID = SOURCE.OwnerID, 
			 TARGET.DefaultFileID = SOURCE.DefaultFileID, 
			 TARGET.Name = SOURCE.Name, 
			 TARGET.Stage = SOURCE.Stage, 
			 TARGET.[Status] = SOURCE.[Status] 
			WHEN NOT MATCHED THEN 
			INSERT(ID,OwnerID,DefaultFileID,Name,Stage,[Status]) VALUES(SOURCE.ID,SOURCE.OwnerID,SOURCE.DefaultFileID,SOURCE.Name,SOURCE.Stage,SOURCE.[Status]);

			MERGE [dbo].[RewardProject] AS TARGET
			USING RewardProject_Staging AS SOURCE ON (TARGET.ID = SOURCE.ID) 
			WHEN MATCHED THEN 
			UPDATE SET TARGET.PopularityScore = SOURCE.PopularityScore, 
			 TARGET.DatePopularityModified = SOURCE.DatePopularityModified
			WHEN NOT MATCHED THEN INSERT(ID,RewardlegacyProjectID,PopularityScore,DatePopularityModified) 
			VALUES(SOURCE.ID,SOURCE.ID,SOURCE.PopularityScore,SOURCE.DatePopularityModified);
			
			-- update is enrolled if they dont match (true on one false on other) then you are enrolled
			MERGE [dbo].[RewardUser] AS TARGET
			USING RewardUser_Staging AS SOURCE
			ON (TARGET.UserID = SOURCE.ID)
			WHEN MATCHED AND TARGET.IsEnrolled != SOURCE.IsEnrolled  THEN
			UPDATE SET  TARGET.IsEnrolled = 1;

			-- this was updateing isenrolled but that mean to enroll you have to go to both stacks and enroll other wise PG took presidence
			MERGE [dbo].[RewardUser] AS TARGET
			USING RewardUser_Staging AS SOURCE
			ON (TARGET.UserID = SOURCE.ID)
			WHEN MATCHED THEN 
			UPDATE SET TARGET.IsBannedOnLegacyCF = SOURCE.IsBanned, 
			TARGET.LastLoginOnLegacyCF = SOURCE.LastLogin
			WHEN NOT MATCHED 
			THEN INSERT(UserID,IsBannedOnLegacyCF,LastLoginOnLegacyCF) 
			VALUES(SOURCE.ID,SOURCE.IsBanned,SOURCE.LastLogin);
		COMMIT TRANSACTION;
	END TRY
	BEGIN CATCH
		ROLLBACK TRANSACTION;
		SELECT @errorMessage = ERROR_MESSAGE();
		RETURN(910);
	END CATCH;
		RETURN(1);
END


/****** Object:  StoredProcedure [dbo].[RP_UserEligibility]    Script Date: 2/4/2014 4:23:04 PM ******/
SET ANSI_NULLS ON





GO


